IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'EST_MOVIMENTO_COMPRAS_PRODUTOS') 
					AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS](
	[CD_CTR_COMPRAS] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[CD_MOV_OP] [int] NOT NULL,
	[VLR_COMPRAS] [money] NOT NULL,
	[VLR_DESC] [money] NOT NULL,
	[VLR_ICMS_SUBS] [money] NOT NULL,
	[VLR_FRETE] [money] NOT NULL,
	[VLR_IPI] [money] NOT NULL,
	[VLR_COMPRAS_LIQ] [money] NOT NULL,
	[VLR_OUTRAS_DESPESAS] [money] NOT NULL,
	[VLR_ICMS_DESONERADO] [money] NOT NULL,
	[QTDE_ITENS] [money] NOT NULL,
 CONSTRAINT [PK_EST_MOVIMENTO_COMPRAS_PRODUTOS] PRIMARY KEY CLUSTERED 
(
	[CD_CTR_COMPRAS] ASC,
	[CD_EMP] ASC,
	[CD_PROD] ASC,
	[CD_MOV_OP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_PRODUTOS_CD_CTR_COMPRAS]  DEFAULT ((0)) FOR [CD_CTR_COMPRAS]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_PRODUTOS_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS] ADD  CONSTRAINT [DF_Table_1_CD_ARV_MERC_LINHA_1]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_PRODUTOS_CD_MOV_OP]  DEFAULT ((0)) FOR [CD_MOV_OP]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_PRODUTOS_VLR_COMPRAS]  DEFAULT ((0)) FOR [VLR_COMPRAS]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_PRODUTOS_VLR_DESC]  DEFAULT ((0)) FOR [VLR_DESC]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_PRODUTOS_VLR_ICMS_SUBS]  DEFAULT ((0)) FOR [VLR_ICMS_SUBS]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_PRODUTOS_VLR_FRETE]  DEFAULT ((0)) FOR [VLR_FRETE]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_PRODUTOS_VLR_IPI]  DEFAULT ((0)) FOR [VLR_IPI]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_PRODUTOS_VLR_COMPRAS_LIQ]  DEFAULT ((0)) FOR [VLR_COMPRAS_LIQ]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_PRODUTOS_VLR_OUTRAS_DESPESAS]  DEFAULT ((0)) FOR [VLR_OUTRAS_DESPESAS]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_PRODUTOS_VLR_ICMS_DESONERADO]  DEFAULT ((0)) FOR [VLR_ICMS_DESONERADO]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_PRODUTOS_QTDE_ITENS]  DEFAULT ((0)) FOR [QTDE_ITENS]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS]  WITH CHECK ADD  CONSTRAINT [FK_EST_MOVIMENTO_COMPRAS_PRODUTOS_EST_MOVIMENTO_COMPRAS] FOREIGN KEY([CD_CTR_COMPRAS])
REFERENCES [dbo].[EST_MOVIMENTO_COMPRAS] ([CD_CTR_COMPRAS])
ON UPDATE CASCADE
ON DELETE CASCADE

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS_PRODUTOS] CHECK CONSTRAINT [FK_EST_MOVIMENTO_COMPRAS_PRODUTOS_EST_MOVIMENTO_COMPRAS]
END